/*
 * Decompiled with CFR 0.152.
 */
package filenet.sim.toolkit.designer.properties;

import filenet.sim.api.VWScenarioWorkflowDefinition;
import filenet.sim.toolkit.designer.properties.VWSIMPropertyData;
import filenet.sim.toolkit.designer.properties.VWSIMScenarioPropertiesDialog;
import filenet.sim.toolkit.designer.properties.workflowstab.VWSIMWorkflowsTab;
import filenet.vw.api.VWWorkflowDefinition;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.utils.mapui.VWMapAttribs;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.WindowListener;
import javax.swing.JPanel;
import javax.swing.event.EventListenerList;

public class VWSIMDesignerPropertiesPanel
extends JPanel {
    private VWSIMWorkflowsTab m_workflowsTab = null;
    private VWSIMScenarioPropertiesDialog m_scenarioPropertiesDialog = null;
    private VWSIMPropertyData m_propertyData = null;
    private EventListenerList m_listenerList = null;

    public void init(VWSIMPropertyData propertyData) {
        this.m_propertyData = propertyData;
        this.m_workflowsTab = new VWSIMWorkflowsTab();
        this.m_workflowsTab.init(this.m_propertyData);
        this.setLayout(new BorderLayout());
        this.add((Component)this.m_workflowsTab, "Center");
    }

    public boolean isDirty() {
        return this.m_propertyData.isDirty();
    }

    public void resetDirty() {
        this.m_propertyData.resetDirty();
    }

    public VWScenarioWorkflowDefinition getCurrentSelectedWorkflow() {
        VWScenarioWorkflowDefinition scenarioWFDef = null;
        try {
            VWWorkflowDefinition wfDefinition = this.m_propertyData.getSelectedWorkflowDefinition();
            if (wfDefinition != null) {
                scenarioWFDef = this.m_propertyData.getScenarioDefinition().getWorkflow(wfDefinition.getName());
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return scenarioWFDef;
    }

    public void addScenarioPropertiesWindowListener(WindowListener listener) {
        if (this.m_scenarioPropertiesDialog != null) {
            this.m_scenarioPropertiesDialog.addWindowListener(listener);
        } else {
            if (this.m_listenerList == null) {
                this.m_listenerList = new EventListenerList();
            }
            this.removeScenarioPropertiesWindowListener(listener);
            this.m_listenerList.add(WindowListener.class, listener);
        }
    }

    public void removeScenarioPropertiesWindowListener(WindowListener listener) {
        if (this.m_listenerList != null) {
            this.m_listenerList.remove(WindowListener.class, listener);
        }
    }

    public void displayScenarioPropertiesDialog(boolean bDisplay) {
        if (bDisplay && this.m_scenarioPropertiesDialog == null) {
            this.m_scenarioPropertiesDialog = new VWSIMScenarioPropertiesDialog(this.m_propertyData);
            if (this.m_listenerList != null) {
                Object[] listeners = this.m_listenerList.getListenerList();
                for (int i = listeners.length - 2; i >= 0; i -= 2) {
                    if (listeners[i] != WindowListener.class) continue;
                    this.m_scenarioPropertiesDialog.addWindowListener((WindowListener)listeners[i + 1]);
                }
            }
        }
        if (this.m_scenarioPropertiesDialog != null) {
            this.m_scenarioPropertiesDialog.setVisible(bDisplay);
        }
    }

    public void importWorkflow() {
        if (this.m_workflowsTab != null) {
            this.m_workflowsTab.importWorkflow();
        }
    }

    public void replaceWorkflow() {
        if (this.m_workflowsTab != null) {
            this.m_workflowsTab.replaceWorkflow();
        }
    }

    public void deleteSelectedWorkflow() {
        if (this.m_workflowsTab != null) {
            this.m_workflowsTab.deleteSelectedWorkflow();
        }
    }

    public String getSelectedWorkflowName() {
        if (this.m_workflowsTab != null) {
            return this.m_workflowsTab.getSelectedWorkflowName();
        }
        return null;
    }

    public VWMapAttribs getMapAttributes() {
        if (this.m_workflowsTab != null) {
            return this.m_workflowsTab.getMapAttributes();
        }
        return null;
    }

    public void releaseReferences() {
        if (this.m_workflowsTab != null) {
            this.m_workflowsTab.releaseReferences();
            this.m_workflowsTab = null;
        }
        if (this.m_scenarioPropertiesDialog != null) {
            this.m_scenarioPropertiesDialog.releaseReferences();
            this.m_scenarioPropertiesDialog = null;
        }
        if (this.m_propertyData != null) {
            this.m_propertyData.releaseReferences();
            this.m_propertyData = null;
        }
        if (this.m_listenerList != null) {
            Object[] listeners = this.m_listenerList.getListenerList();
            for (int i = listeners.length - 2; i >= 0; i -= 2) {
                if (listeners[i] != WindowListener.class) continue;
                this.removeScenarioPropertiesWindowListener((WindowListener)listeners[i + 1]);
            }
            this.m_listenerList = null;
        }
    }
}

